/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.config;

import com.ibm.hwmca.fw.util.FileControl;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.WuiConfigBean;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;

public class BonsaiConfigDigester {
    private static final String TRACEMASK_T = "XBUIDIGT";
    private static final String TRACEMASK_F = "XBUIDIGF";
    private static final String TRACEMASK_D = "XBUIDIGD";
    private static final String DFC_FILE_NAME = "iqzddfc.trm";
    private static final String DIGESTER_RULES_FILE_NAME = "digester-rules-wui.xml";
    private static final String CONFIG_FILE_NAME = "wui-config.xml";

    private BonsaiConfigDigester() {
    }

    public static WuiConfigBean getConfigData() throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "--> BonsaiConfigDigester.getConfigData()");
        WuiConfigBean configBean = null;
        try {
            String configPath = BonsaiConfigDigester.getConfigPath();
            File configXML = new File(configPath + CONFIG_FILE_NAME);
            URL rulesXML = new File(configPath + DIGESTER_RULES_FILE_NAME).toURL();
            Digester digester = DigesterLoader.createDigester((URL)rulesXML);
            digester.setValidating(false);
            configBean = (WuiConfigBean)digester.parse(configXML);
        }
        catch (Throwable thr) {
            Trace.trace(TRACEMASK_D, "Exception caught! " + thr.toString());
            throw new BonsaiConfigException(thr);
        }
        Trace.trace(TRACEMASK_T, "<-- BonsaiConfigDigester.getConfigData()");
        return configBean;
    }

    private static String getConfigPath() throws Throwable {
        Trace.trace(TRACEMASK_F, "> BonsaiConfigDigester.getConfigPath()");
        String dfcFile = System.getProperty("CONSOLE_PATH") + DFC_FILE_NAME;
        ArrayList dfcMask = new ArrayList();
        ArrayList dfcPath = new ArrayList();
        FileControl.readDefFile(dfcFile, dfcMask, dfcPath);
        String path = FileControl.getFilePath(dfcFile, "bonsai", dfcMask, dfcPath);
        Trace.trace(TRACEMASK_F, "< BonsaiConfigDigester.getConfigPath() (return: " + path + ")");
        return path;
    }
}

